#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Marshmallow tunnelMod02.fsh   by leon   
//https://www.shadertoy.com/view/wlcczr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//
// Marshmallow tunnel
//
// Leon Denise 2020.12.19
// Licensed under hippie love conspiracy
//

// repeat coordinate
#define repeat(p,r) (mod(p,r)-r/2.)

// rotation matrix
mat2 rotation(float a)
{
    float c = cos(a), s = sin(a);
    return mat2(c,-s,s,c);
}

float material;

// Dave Hoskins
// https://www.shadertoy.com/view/4djSRW
float hash12(vec2 p)
{
	vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}

// signed distance field
float map(vec3 pos)
{
    vec3 p = pos;
    float dist = 100.;
    float shape = 100.;
    float falloff = 1.0;
    float range = 2.4;
    const int count = 5;
    
    // rotation based on z axis
    float t = p.z*0.2+213.+iTime*0.1;
    
    for (int index = 0; index < count; ++index)
    {
        // fold space (.xz = .xy is an error, but interesting enough to be saved in a shadertoy for later)
        pos.xz = abs(pos.xy)-range*falloff;
        
        // rotations
        pos.yz *= rotation(t/falloff);
        pos.xy *= rotation(t/falloff);
        
        // shape
        shape = length(pos)-2.6*falloff;
        
        // material system inspired by evvvvil
        material = shape < dist ? float(index) : material;
        
        // add to volume
        dist = min(dist, shape);
        
        falloff /= 1.2;
    }

    // shell
    dist = abs(dist);

    // surface matter
    vec3 seed = pos * 12.;
    float matter = sin(seed.x + abs(cos(seed.y)));
    matter = pow(abs(matter), 0.3);
    matter += pow(abs(sin(length(pos)*10.)), 0.3) * 2.;
    dist -= matter * 0.1;

    return dist;
}
#define color fragColor
#define coordinate fragCoord
//void mainImage( out vec4 color, in vec2 coordinate )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    color = vec4(0,0,0,1);
    
    // coordinates
    vec2 uv = 2.*(coordinate-0.5*iResolution.xy)/iResolution.y;
    vec3 camera = vec3(2,1,-4);
    vec3 ray = normalize(vec3(uv,1.));
    float rng = hash12(coordinate+iTime);
    
    // camera animation
    camera.y += sin(iTime*0.3)*0.05;
    
    // mouse control
    vec2 mouse = (iMouse.xy / iResolution.xy * 2. - 1.) * step(0.5, iMouse.z);
    ray.yz *= rotation(-mouse.y);
    ray.xz *= rotation(.2-mouse.x);
    
    // raymarch iteration
    const int count = 40;
    for (int index = 0; index < count; ++index)
    {
        // distance field
        float dist = map(camera);
        
        // collide with volume
        if (dist < 0.1)
        {
            // coloring
            float shade = float(count-index)/float(count);
            
            // palette from Inigo Quilez
            // https://iquilezles.org/articles/palettes
            vec3 tint = vec3(0.75) + vec3(0.25) * cos(3.14*(vec3(1,2,3)*(shade*1.1+material+uv.x*.1)));
            color = vec4(tint*shade, 1);
            break;
        }
        
        // march
        dist *= 0.6 + 0.1 * rng;
        camera += ray * dist;
    }
    
    // fade in
    color *= smoothstep(0.0, 1.0, iTime);
    
    // temporal dithering
    fragColor = mix(color, texture2D(texture0, coordinate/iResolution.xy), 0.6);


/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

